# -*- coding: utf-8 -*-
"""
Created on Thu Oct 14 18:44:29 2021

@author: perlita
@title: project 04
"""

import numpy as np
import sklearn as sk
import sklearn.datasets
import sklearn.model_selection
import timeit

dataset = sk.datasets.fetch_california_housing()

feature_vectors = dataset.data
y = dataset.target
column_names = dataset.feature_names

X = np.insert(feature_vectors, 0, 1, axis = 1)

X_train, X_val, Y_train, Y_val = \
    sk.model_selection.train_test_split(X, y, 
                                        train_size = .75,
                                        random_state = 123)

def L(b, X, y):
    
    N = X.shape[0]
    estimate = X @ b - y
    norm = np.linalg.norm(estimate)
    return (norm**2)/N

def grad_L(b, X, y):
    
    N = X.shape[0]
    estimate = X @ b - y
    return (2/N)*(X.T@estimate)

def normalize_L(X, y):
    
    b = np.linalg.solve(X.T@X, X.T@y)
    return b


d = X_train.shape[1] - 1
beta1 = np.zeros(d+1)

max_iter = 10000
t = 2e-7
epsilon = 1e-7
L_vals = []

starttimer1 = timeit.default_timer()

for k in range(max_iter):
    
    gradL = grad_L(beta1, X_train, Y_train)
    L_vals.append(L(beta1, X_train, Y_train))
    if np.linalg.norm(gradL) < epsilon:
        break
    
    beta1 = beta1 - t*gradL

minimizeL1 = L(beta1, X_train, Y_train)    
print('Minimizing L using the gradient (call it Beta 1): ', minimizeL1)
print()

starttimer2 = timeit.default_timer()

beta2 = normalize_L(X_train, Y_train)
minimizeL2 = L(beta2, X_train, Y_train)
print('Minimizing L using the normal equation (call it Beta 2): ', minimizeL2)
print()

N_val = X_val.shape[0]

predictions1 = X_val @ beta1
squaredErrors1 = (predictions1 - Y_val)**2
meanSquareError1 = (1/N_val)*np.sum(squaredErrors1)
print('Mean Squared Error on Beta 1: ', meanSquareError1)
print()

predictions2 = X_val @ beta2
squaredErrors2 = (predictions2 - Y_val)**2
meanSquareError2 = (1/N_val)*np.sum(squaredErrors2)
print('Mean Squared Error on Beta 2: ', meanSquareError2)
print()

print('Time it took to minimize L with Beta 1: ',
      timeit.default_timer() - starttimer1)
print()
print('Time it took to minimize L using Beta 2: ',
      timeit.default_timer() - starttimer2)



